#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{
	/// <summary>
	/// Summary description for VbecsReport.
	/// </summary>
	[TestFixture]
	public class BOL_CostAccountingReport : BaseTest 
	{
		System.DateTime _startDate = System.DateTime.Now.AddYears(-1);
		System.DateTime _endDate = System.DateTime.Now.AddDays(1);
		BOL.CostAccountingReport _tstCAR;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
			this._tstCAR = new BOL.CostAccountingReport(this._startDate, this._endDate);
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.CostAccountingReport tmpCAR = new BOL.CostAccountingReport();

			Assert.IsNotNull(tmpCAR);
			Assert.AreEqual(DateTime.Today.AddDays(-1),tmpCAR.StartDate,"StartDate");
			Assert.AreEqual(DateTime.Today.AddDays(-1).AddHours(23).AddMinutes(59).AddSeconds(59),tmpCAR.EndDate,"EndDate");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull(this._tstCAR);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}


		[Test]
		public void GetCostAccountingReport_IncomingShipment_Pass()
		{
			DataTable dtTest = this._tstCAR.GetCostAccountingReport(Common.CostAccountingReportSections.IncomingShipment);
			Assert.IsTrue(dtTest.Rows.Count > 0);
		}

		[Test]
		public void GetCostAccountingReport_OutgoingShipment_Pass()
		{
			DataTable dtTest = this._tstCAR.GetCostAccountingReport(Common.CostAccountingReportSections.OutgoingShipment);
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetCostAccountingReport_UnitModification_Pass()
		{
			DataTable dtTest = this._tstCAR.GetCostAccountingReport(Common.CostAccountingReportSections.Modifications);
			Assert.IsTrue(dtTest.Rows.Count > 0);
		}

		[Test]
		public void GetCostAccountingReport_OffSiteABID_Pass()
		{
			DataTable dtTest = this._tstCAR.GetCostAccountingReport(Common.CostAccountingReportSections.OffSiteABID);

			//Create data if none exists
			if (dtTest.Rows.Count == 0)
			{
				DataCreator.CreateCrossmatchedBloodUnitTestData();

				UnitTestUtil.RunSQL(" UPDATE SpecimenTest " + 
					" SET OffsiteIndicator = 1, " + 
					"     OffsiteLocation = 'Yo Mammas House', " + 
					"     OffsiteCost = 19 " + 
					" WHERE SpecimenTestGuid IN ( " + 
					" SELECT TOP 1 st.SpecimenTestGuid " +
					" FROM SpecimenTest st " + 
					" JOIN PatientSpecimen ps ON st.PatientSpecimenGuid = ps.patientspecimenguid " + 
					" JOIN dbo.Patient P ON P.PatientGuid = PS.PatientGuid " + 
					" WHERE st.DivisionCode = '" + this.TestDivisionCode + "' " + 
					"   AND st.TestDate BETWEEN '" + this._startDate.ToString() + "' AND '" + this._endDate.ToString() + "') ");

			}

            dtTest = this._tstCAR.GetCostAccountingReport(Common.CostAccountingReportSections.OffSiteABID);    
			Assert.IsTrue(dtTest.Rows.Count > 0);
		}

		[Test]
		public void GetCostAccountingReport_DiscardedUnits_Pass()
		{
			DataTable dtTest = this._tstCAR.GetCostAccountingReport(Common.CostAccountingReportSections.DiscardedUnits);
			Assert.IsTrue(dtTest.Rows.Count > 0);
		}

		[Test]
		public void GetCostAccountingReport_Main_Pass()
		{
			DataTable dtTest = this._tstCAR.GetCostAccountingReport(Common.CostAccountingReportSections.Main);

			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");
			Assert.IsTrue(dtTest.Columns.Contains("IncomingShipmentsVisibleIndicator"));
			Assert.IsTrue(dtTest.Columns.Contains("OutgoingShipmentsVisibleIndicator"));
			Assert.IsTrue(dtTest.Columns.Contains("UnitModificationsVisibleIndicator"));
			Assert.IsTrue(dtTest.Columns.Contains("OffSiteABIDsVisibleIndicator"));
			Assert.IsTrue(dtTest.Columns.Contains("DiscardedUnitsVisibleIndicator"));
			Assert.IsTrue(dtTest.Columns.Contains("InactivatedUnitsVisibleIndicator"));
		}

		[Test]
		public void GetCostAccountingReport_Fail()
		{
			DataTable dtTest = this._tstCAR.GetCostAccountingReport(Common.CostAccountingReportSections.Unknown);
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

        [Test]
        public void GenerateReport_Pass()
        {
            this._tstCAR.StartDate = DateTime.Now.AddDays(-30);
            this._tstCAR.EndDate = DateTime.Now;
           BOL.CostAccountingReport rpt = new BOL.CostAccountingReport();
            Assert.IsFalse(rpt == null);
        }

	    [Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateReport_Fail()
		{
		}

		[Test] 
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report to printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report to printer
		}
	}
}

#endif
